# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


# data_extraction_system/tests/test_validation_agent.py
import unittest
from unittest.mock import patch, MagicMock
from google.adk.runners import InMemoryRunner
from data_extraction_system.agents.validation_agent import validation_agent

class TestValidationAgent(unittest.TestCase):

    @patch("data_extraction_system.agents.validation_agent.validate_data")
    @patch("google.adk.runners.InMemoryRunner.run_async")
    def test_agent_validates_data(self, mock_run_async, mock_validate_data):
        """Tests that the validation agent validates data."""
        # Mock the return value of the actual validate_data function
        mock_validate_data.return_value = True

        # Mock the async iterator returned by run_async
        mock_event = MagicMock()
        mock_event.author = "ValidationAgent"
        mock_event.content.parts[0].text = "Data validated successfully."
        mock_run_async.return_value = [mock_event]

        runner = InMemoryRunner(agent=validation_agent, app_name="TestApp")

        async def run_main():
            await runner.run_async(user_id="testuser", session_id="testsession", new_message="Validate data")

        asyncio.run(run_main())

        # Assert that validate_data was called
        mock_validate_data.assert_called_once()
        # Assert that run_async was called
        mock_run_async.assert_called_once()

if __name__ == "__main__":
    unittest.main()
