# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


# data_extraction_system/models/extraction_schema.py
from pydantic import BaseModel, Field
from typing import Optional

class MortgageData(BaseModel):
    """Schema for extracted mortgage data."""
    borrower_name: str = Field(description="Name of the borrower.")
    loan_amount: float = Field(description="Amount of the loan.")
    property_address: str = Field(description="Address of the property.")
    loan_type: Optional[str] = Field(default=None, description="Type of the loan (e.g., fixed-rate, adjustable-rate).")
    interest_rate: Optional[float] = Field(default=None, description="Interest rate of the loan.")
