# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


# data_extraction_system/main.py
import asyncio
import os
from google.adk.runners import InMemoryRunner
from data_extraction_system.agents.document_processor_agent import document_processor_agent
from dotenv import load_dotenv

load_dotenv()

async def main():
    """Main function to run the data extraction system."""

    runner = InMemoryRunner(agent=document_processor_agent, app_name="MortgageDataExtraction")

    user_id = "user123"
    session_id = "session456"
    document_path = os.getenv("SAMPLE_DOCUMENT_PATH") # Path to a sample mortgage document (e.g., PDF)

    if not document_path:
        print("Error: SAMPLE_DOCUMENT_PATH environment variable not set.")
        return

    initial_message = f"Process the mortgage document located at: {document_path}"

    try:
        async for event in runner.run_async(user_id=user_id, session_id=session_id, new_message=initial_message):
            print(f"Event: {event.author}: {event.content.parts[0].text if event.content and event.content.parts else ''}")
    except Exception as e:
        print(f"An error occurred during the run: {e}")

if __name__ == "__main__":
    asyncio.run(main())
