# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


# data_extraction_system/agents/validation_agent.py
from google.adk.agents import LlmAgent
from google.adk.models import Gemini
from data_extraction_system.models.extraction_schema import MortgageData
from google.adk.tools import FunctionTool
from pydantic import ValidationError

def validate_data(extracted_data: dict) -> bool:
    """Validates the extracted data against the MortgageData schema."""
    try:
        MortgageData(**extracted_data)
        return True
    except ValidationError as e:
        print(f"Validation Error: {e}")
        return False

validation_agent = LlmAgent(
    name="ValidationAgent",
    description="Validates the extracted data against the MortgageData schema.",
    model=Gemini(model="gemini-2.5-flash-lite"),
    instruction="You are responsible for validating the extracted data against the MortgageData schema. Ensure that all required fields are present and that the data types are correct. Return True if the data is valid, and False otherwise.",
    tools=[
        FunctionTool(func=validate_data)
    ]
)
