# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


from pydantic import BaseModel
from typing import Optional, List

class EmailContent(BaseModel):
    subject: str
    body: str

class CampaignMetrics(BaseModel):
    campaign_id: str
    total_sessions: int
    total_users: int
    total_conversions: int
    total_events: int
    average_conversions_per_session: float
    daily_breakdown: List[dict]

class CampaignReport(BaseModel):
    campaign_goal: str
    performance_summary: str
    key_metrics: dict
    recommendations: Optional[str] = None

class UserProfile(BaseModel):
    user_id: str
    email: str
    name: Optional[str] = None
    purchase_history: Optional[List[str]] = None
    engagement_score: Optional[int] = None
