# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


from langchain_core.prompts import ChatPromptTemplate
from langchain_core.runnables import RunnablePassthrough
from langchain_google_genai import ChatGoogleGenerativeAI

class PersonalizationAgent:
    def __init__(self, llm: ChatGoogleGenerativeAI):
        self.llm = llm
        self.prompt = ChatPromptTemplate.from_messages([
            ("system", "You are an expert in email personalization. Your task is to tailor existing email content to specific audience segments or individual user data."),
            ("user", "Personalize the following email content for the target audience: {target_audience}\n\nOriginal Content:\n{email_content}\n\nProvide the personalized email content, including a revised subject line if appropriate.")
        ])

    def personalize_content(self, email_content: str, target_audience: str) -> str:
        chain = self.prompt | self.llm
        response = chain.invoke({
            "email_content": email_content,
            "target_audience": target_audience
        })
        return response.content
