# Mailing List Engagement System

This project implements a multi-agent system designed to automate and enhance mailing list engagement. It leverages the Google AI ecosystem, including Vertex AI for generative models, and integrates with external services like SendGrid for email delivery and Google Analytics for performance tracking.

## Features

*   **Content Creation:** Generates engaging email content tailored to different audience segments.
*   **Personalization:** Customizes email content based on user data and past interactions.
*   **Engagement Analysis:** Analyzes email campaign performance using metrics from Google Analytics.
*   **List Management:** Assists in managing mailing lists, including segmentation and hygiene.
*   **Reporting:** Provides comprehensive reports on campaign performance and engagement.

## Project Structure

```
~/MAP/mailing_list_engagement/
├── __init__.py
├── main.py
├── agents/
│   ├── __init__.py
│   ├── content_creation_agent.py
│   ├── engagement_analysis_agent.py
│   ├── list_management_agent.py
│   ├── personalization_agent.py
│   └── reporting_agent.py
├── tools/
│   ├── __init__.py
│   ├── sendgrid_api.py
│   ├── vertex_ai_tools.py
│   └── google_analytics_api.py
├── models/
│   ├── __init__.py
│   └── data_models.py
├── prompts/
│   ├── __init__.py
│   ├── content_creation_prompts.py
│   ├── engagement_analysis_prompts.py
│   ├── list_management_prompts.py
│   ├── personalization_prompts.py
│   └── reporting_prompts.py
├── deployment/
│   ├── __init__.py
│   ├── deploy.py
│   └── test_deployment.py
├── eval/
│   ├── __init__.py
│   ├── eval_data/
│   │   └── test_cases.json
│   └── test_eval.py
├── tests/
│   ├── __init__.py
│   ├── test_content_creation_agent.py
│   ├── test_engagement_analysis_agent.py
│   ├── test_list_management_agent.py
│   ├── test_personalization_agent.py
│   └── test_reporting_agent.py
├── pyproject.toml
└── README.md
```

## Setup and Installation

1.  **Clone the repository:**
    ```bash
    git clone <repository_url>
    cd mailing_list_engagement
    ```

2.  **Install dependencies:**
    ```bash
    pip install -r requirements.txt
    ```

3.  **Environment Variables:**
    Create a `.env` file in the root directory (`~/MAP/mailing_list_engagement/`) with the following variables:

    ```env
    GOOGLE_API_KEY=<your_google_api_key>
    SENDGRID_API_KEY=<your_sendgrid_api_key>
    GOOGLE_ANALYTICS_PROPERTY_ID=<your_google_analytics_property_id>
    GOOGLE_ANALYTICS_VIEW_ID=<your_google_analytics_view_id>
    VERTEX_AI_PROJECT_ID=<your_vertex_ai_project_id>
    VERTEX_AI_LOCATION=<your_vertex_ai_location>
    ```

    *   **`GOOGLE_API_KEY`**: Your API key for Google services.
    *   **`SENDGRID_API_KEY`**: Your API key for SendGrid.
    *   **`GOOGLE_ANALYTICS_PROPERTY_ID`**: Your Google Analytics Property ID (e.g., '123456789').
    *   **`GOOGLE_ANALYTICS_VIEW_ID`**: Your Google Analytics View ID (e.g., '123456789').
    *   **`VERTEX_AI_PROJECT_ID`**: Your Google Cloud Project ID for Vertex AI.
    *   **`VERTEX_AI_LOCATION`**: The region for your Vertex AI resources (e.g., 'us-central1').

## Usage

Run the main application script:

```bash
python main.py
```

The `main.py` script orchestrates the agents to perform various mailing list engagement tasks. You can modify this script to define specific campaign goals or workflows.

## Deployment

To deploy the system, navigate to the `deployment` directory and follow the instructions in `deploy.py` and `test_deployment.py`.

```bash
cd deployment
python deploy.py
```

## Testing

Run the functional tests to ensure the system is working as expected:

```bash
pytest
```

## Contributing

Contributions are welcome! Please refer to `CONTRIBUTING.md` for more information.
