# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


# utils/helper_functions.py
from web3 import Web3

def validate_address(address: str) -> bool:
    """Validates an Ethereum address."""
    if not isinstance(address, str):
        return False
    return Web3.is_address(address)
