# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


from google_adk.agents import LlmAgent
from google_adk.tools import FunctionTool
from google_adk.models import Gemini
from tools.lending_protocol_api import adjust_lending_position
from tools.blockchain_api import get_market_conditions

yield_optimizer_agent = LlmAgent(
    name="YieldOptimizerAgent",
    description="Analyzes market conditions and adjusts lending strategies to maximize USDC yields on Base blockchain.",
    model=Gemini(model="gemini-2.5-flash-lite"),
    instruction="You are a yield optimization expert. Your goal is to analyze market conditions and adjust lending strategies to maximize USDC yields on the Base blockchain. Use the blockchain_api to get market conditions and lending_protocol_api to adjust lending positions. Prioritize maximizing yield while considering risk.",
    tools=[
        FunctionTool(
            name="get_market_data",
            func=get_market_conditions,
            description="Retrieves current market conditions on the Base blockchain, including interest rates, volatility, and liquidity.",
        ),
        FunctionTool(
            name="adjust_position",
            func=adjust_lending_position,
            description="Adjusts the lending position based on market conditions. Requires amount, lending protocol, and other relevant parameters.",
        ),
    ],
)
