# Copyright © 2025 Intellisol LLC. All Rights Reserved.
#
# This file is part of the Intellisol Automation System.
#
# This software is a trade secret of Intellisol LLC. It is proprietary and
# confidential information. You may not disclose this software or any part of it
# to any third party, or use it in any way not expressly authorized by the
# accompanying End-User License Agreement (EULA).
#
# UNPUBLISHED. RIGHTS RESERVED.


from google_adk.agents import LlmAgent
from google_adk.tools import FunctionTool
from google_adk.models import Gemini
from .lending_agent import lending_agent
from .yield_optimizer_agent import yield_optimizer_agent
from .risk_manager_agent import risk_manager_agent
import asyncio

# Define the orchestrator agent
orchestrator_agent = LlmAgent(
    name="OrchestratorAgent",
    description="Manages the overall workflow and coordinates other agents to maximize USDC lending yields on Base blockchain.",
    model=Gemini(model="gemini-2.5-flash-lite"),
    instruction="You are a master orchestrator. Your goal is to maximize USDC lending yields on Base blockchain using other specialized agents. First, instruct the LendingAgent to enter an initial lending position. Then, continuously monitor and optimize the position using the YieldOptimizerAgent and RiskManagerAgent. Ensure the system is secure, robust, and compliant.",
    tools=[
        FunctionTool(
            name="coordinate_agents",
            func=lambda instruction, agent_name: asyncio.run(globals()[agent_name].run_async(instruction)),
            description="Coordinates other agents by providing instructions and monitoring their progress.",
        ),
        lending_agent,
        yield_optimizer_agent,
        risk_manager_agent,
    ],
)
